## Previous versions
## * runZIPimage01.r (validation 90.9%)
## This version is simplified so that it can be used to measure a computer performance, for CA class.
## July, 13th, 2012

rm(list=ls())

## Import Data

  train.zip <- read.table('zip.train')
  ## check data type
  class(train.zip)

  numzip <- apply(train.zip,c(1,2),as.numeric)
  ## check data type
  class(numzip)

  ## check how data looks like
  image(seq(1,16), seq(1,16), t(apply(matrix(numzip[2,-1],16,16),1,rev)))
  
## Prepare Data

  X <- t(numzip[,-1])  # X is D x N
  T <- t(numzip[,1])   # T is 1 x N
  N <- ncol(X)

## Separate Data into Training and Validation Sets

  id.rand <- sample(N)

  marker <- round(0.75*N)

  train.X <- X[,id.rand[1:marker]]
  train.T <- T[,id.rand[1:marker]]

  validate.X <- X[,id.rand[-1:-marker]]
  validate.T <- T[,id.rand[-1:-marker]]

## Train Network

  source('nnMultiClassNaNStop01.r')
  train.T.K <- makeIndicators(train.T)

  net <- nnTrain(train.X,train.T.K, 
    nHiddens=40, rhoh=0.01, rhoo=0.001, wmax=0.05, nEpochs=3000, net=NULL, graph=FALSE)

## Validate Network (to choose model: nHiddens, but I have done that and found M=40 is O.K.)

  validate.y <- nnOutput(net,validate.X)

  CorrectRatio <- sum(which.class(validate.y)==validate.T)/length(validate.T)

cat("\n\nCorrect Ratio is : ", CorrectRatio)