# MIPS32 assembly code for Computer Architecture Class Assignment
# By Tatpong Katanyukul, CoE, Khon Kaen University
# Created:	 August 2011
# Last Modified: July, 30th, 2012: picoasm works.

.data 0x10010000    ## specific address to make sure that address is valid (ending w/ 0x0, 0x4, 0x8, 0xC)
myasm:	.asciiz 	"asm \naddi $s6, $s6, 3\n ISA \naddi $s6, $s6, 3\nMIPS32;"

.data 0x10010040
mccode: .asciiz		"!!!! The m/c code will be here. !!!!"
					# after picoasm, expect to see "00000000;22d60003;00000000;22d60003"

.data 0x10010080
assemblytable: 	.asciiz	"addi $s6, $s6, 3\n"

.data 0x100100C0
mcbintable:		.word	0x22d60003


.globl main
.text
main:

# call procedure picoassembler

	# passing parameter values
	la $a0, myasm			# $a0 <- base address of source assembly
	la $a1, mccode			# $a1 <- base address of target m/c code
	la $a2, assemblytable	# $a2 <- base address of mapping assembly table
	la $a3, mcbintable		# $a2 <- base address of mapping m/c binary table

## DEBUG

	lw $t0, 0($a0)
	lw $t0, 0($a1)
	lw $t0, 0($a2)
	lw $t0, 0($a3)
## END DEBUG	
	
	# call procedure
	jal picoasm		

# call procedure picoloader

	# passing parameter values
	move $a0, $v0   		# $a0 <- $v0 returned number of lines translated
	la $a1, mccode			# $a1 <- base address of target m/c code
	la $a2, loadingarea		# $a2 <- base address of loading area
	
	# call procedure
	jal picoloader	

end:
	li 	$v0,10 		# System call code to Exit
	syscall 		# Call SPIM-OS to Exit the program

	
############################################################################	
picoasm:
	# $a0 : base address of source assembly
	# $a1 : base address of target m/c code
	# $a2 : base address of mapping assembly table
	# $a3 : base address of mapping m/c binary table

	# return $v0 : a number of lines translated
############################################################################	

# initialization

	add $t0, $a0, $zero	# $t0 <- source pointer
	add $t1, $a1, $zero	# $t1 <- target pointer
	add $t2, $zero, $zero   # $t2 counts the number of lines translated.

readeachline:	
# call procedure readline
	
	# prepare to call
	addi $sp, $sp, -24		# prepare stack for 6 variables
	sw $ra, 20($sp)
	sw $t0, 16($sp)
	sw $t1, 12($sp)
	sw $t2, 8($sp)
	sw $a2, 4($sp)
	sw $a3, 0($sp)
	
	# arguments
	move $a0, $t0			# source pointer
	#$a2					# base address of mapping assembly table
	
	jal readline
	
	# after call
	lw $a3, 0($sp)
	lw $a2, 4($sp)
	lw $t2, 8($sp)
	lw $t1, 12($sp)
	lw $t0, 16($sp)
	lw $ra, 20($sp)
	addi $sp, $sp, 24		# adjust stack back

	move $t3, $v0			# readline.$v0 : 0 = no match, 1 = match, 2 = terminate
	move $t0, $v1			# readline.$v1 : source pointer after the line
	
# check if it is terminated
	li $t4, 2
	beq $t3, $t4, endpicoasm

# No, not terminated. Keep going
# increment line counter

	addi $t2, $t2, 1

# check if it is matched
	li $t4, 1
	beq $t3, $t4, itsmatched

# No, not matched. Put 0x00000000 into the target
	li $t5, 0x00000000
	sw $t5, 0($t1)
	addi $t1, $t1, 4
	
	j readeachline
	
endpicoasm:	
	move $v0, $t2   # $v0 : a number of lines translated
	jr $ra			# return

# It's matched. Put binary m/c into the target
itsmatched:
	lw $t5, 0($a3)
	sw $t5, 0($t1)
	addi $t1, $t1, 4
	
	j readeachline
	
############################################################################	
readline:
#	$a0 : source text pointer
#	$a2	: base address of a word-to-match

#   return $v0			# 0 = no match, 1 = match, 2 = terminate
#	return $v1			# $v2 = source pointer after readline	
############################################################################	

readSrc:
	lb $t0, 0($a0)		# load byte of the source text
	addi $a0, $a0, 1	
	
# check if it is termination code.
	li $t1, 0x3B		# 0x3B represents ';'
	bne $t0, $t1, noterm

# yes, it's terminated.
terminated:	
	li $v0, 2
	move $v1, $a0
	
	jr $ra 				# return
	
# no, it's not terminated.
noterm:	

# check if it is an end of line.
	li $t1, 0x0A		# 0x0A represents '\n'
	bne $t0, $t1, noendline

# yes, it's an end of line.
	# read matching word
	lb $t2, 0($a2)		# load byte of the matching table
	addi $a2, $a2, 1
# check if src == matching.
	bne $t0, $t2, nomatch
# yes, it's matched.
	li $v0, 1
	move $v1, $a0
	
	jr $ra 				# return

# no, it's not matched.
nomatch:
	li $v0, 0
	move $v1, $a0
	
	jr $ra 				# return	
	
# no, it's not an end of line.	
noendline:	
	# read matching word
	lb $t2, 0($a2)		# load byte of the matching table
	addi $a2, $a2, 1
# check if src == matching.
	bne $t0, $t2, nomatchnoend
# yes, it's matched. But, not finish yet.
	# next round
	j readSrc

# no, it's not matched nor end.
nomatchnoend:
	lb $t0, 0($a0)		# load byte of the source text
	addi $a0, $a0, 1	

# check if it is termination code.
	li $t1, 0x3B		# 0x3B represents ';'
	bne $t0, $t1, nomatchnoterm
# yes, it's terminated.
	j terminated
# no, it's not terminated nor matched.
nomatchnoterm:
# check if it is an end of line.
	li $t1, 0x0A		# 0x0A represents '\n'
	bne $t0, $t1, nomatchnoend
# yes, it's the end of line, but no match.	
	li $v0, 0
	move $v1, $a0
	
	jr $ra 				# return	
	
############################################################################		
picoloader:
	# Program has to be put in address between 0x400000 and 0x10000000
	# (1) load data from mccode to loadedprogram
	# (2) add jump back to rendezvous at the end of loadedprogram
	# PC = target addr.(loaded program)

	# a0 : number of instructions
	# a1 : base address of mccode
	# a2 : base address of loading area
############################################################################	
# DEBUG
	li $s6, 2
	
	addi $sp, $sp, -4		# prepare stack for 1 item
	sw $ra, 0($sp)
	
# load data pointed by $a1 to loading area pointed by $a2 for a number of instructions by $a0

# Check if there is sth to load
loading:
	beqz $a0, loadingdone
	lw $t0, 0($a1)
	sw $t0, 0($a2)
	addi $a0, $a0, -1	
	addi $a1, $a1, 4
	addi $a2, $a2, 4
	j loading

loadingdone:
# Add "jr $ra" to the end of loading area
	li $t4, 0x03E00008
	sw $t4, 0($a2)

# run loaded program
	jal loadingarea

	
	lw $ra, 0($sp)
	addi $sp, $sp, 4		# adjust stack back
	
	
	jr $ra			# return
	
loadingarea:
	nop				# dummy for loaded program
	nop
	nop
	nop
	nop
	